---
name: "ansible-role-creator"
description: |
  Create ansible role creator operations. Auto-activating skill for DevOps Advanced.
  Triggers on: ansible role creator, ansible role creator
  Part of the DevOps Advanced skill category. Use when working with ansible role creator functionality. Trigger with phrases like "ansible role creator", "ansible creator", "ansible".
allowed-tools: "Read, Write, Edit, Bash(cmd:*), Grep"
version: 1.0.0
license: MIT
author: "Jeremy Longshore <jeremy@intentsolutions.io>"
---

# Ansible Role Creator

## Overview

This skill provides automated assistance for ansible role creator tasks within the DevOps Advanced domain.

## When to Use

This skill activates automatically when you:
- Mention "ansible role creator" in your request
- Ask about ansible role creator patterns or best practices
- Need help with advanced devops skills covering kubernetes, terraform, advanced ci/cd, monitoring, and infrastructure as code.

## Instructions

1. Provides step-by-step guidance for ansible role creator
2. Follows industry best practices and patterns
3. Generates production-ready code and configurations
4. Validates outputs against common standards

## Examples

**Example: Basic Usage**
Request: "Help me with ansible role creator"
Result: Provides step-by-step guidance and generates appropriate configurations


## Prerequisites

- Relevant development environment configured
- Access to necessary tools and services
- Basic understanding of devops advanced concepts


## Output

- Generated configurations and code
- Best practice recommendations
- Validation results


## Error Handling

| Error | Cause | Solution |
|-------|-------|----------|
| Configuration invalid | Missing required fields | Check documentation for required parameters |
| Tool not found | Dependency not installed | Install required tools per prerequisites |
| Permission denied | Insufficient access | Verify credentials and permissions |


## Resources

- Official documentation for related tools
- Best practices guides
- Community examples and tutorials

## Related Skills

Part of the **DevOps Advanced** skill category.
Tags: kubernetes, terraform, helm, monitoring, iac
