# intuition-machine

Technical briefing infographic style with aged paper and bilingual labels

## Design Aesthetic

Academic/technical briefing style with clean 2D or isometric technical illustrations. Information-dense but organized with clear visual hierarchy. Vintage blueprint aesthetic with modern clarity. Multiple explanatory elements with bilingual callouts.

## Background

- Color: Aged Cream (#F5F0E6)
- Texture: Subtle paper texture with light creases, vintage technical print feel

## Color Palette

| Role | Color | Hex | Usage |
|------|-------|-----|-------|
| Background | Aged Cream | #F5F0E6 | Primary background |
| Paper Texture | Warm White | #F5F0E1 | Blueprint effect |
| Primary Text | Dark Maroon | #5D3A3A | Headlines, titles |
| Body Text | Near Black | #1A1A1A | Content text |
| Accent 1 | Teal | #2F7373 | Primary illustrations |
| Accent 2 | Warm Brown | #8B7355 | Secondary elements |
| Accent 3 | Maroon | #722F37 | Emphasis |
| Outline | Deep Charcoal | #2D2D2D | Element outlines |

## Visual Elements

- Isometric 3D or flat 2D technical diagrams
- Explanatory text boxes with labeled content
- Bilingual callout labels (English + Chinese)
- Faded thematic background patterns
- Clean black outlines on elements
- Split or triptych layouts
- Key insight boxes

## Style Rules

### Do

- Include multiple text boxes with content
- Use bilingual labels for key elements
- Add faded thematic background patterns
- Maintain aged paper texture
- Create clear visual hierarchy

### Don't

- Create photorealistic 3D renders
- Leave illustrations without explanatory text
- Add stamps or watermarks in corners
- Use gradients or glossy effects
- Make it look too modern/digital

## Best For

Technical explanations, concept breakdowns, academic content, research summaries, bilingual audiences, knowledge documentation
