Create a knowledge biography comic page following these guidelines:

## Image Specifications

- **Type**: Comic book page with multiple panels
- **Orientation**: Portrait (vertical)
- **Aspect Ratio**: 2:3
- **Style**: See style-specific reference for visual guidelines

## Panel Structure

### Panel Borders
- Clean black lines (1-2px) around each panel
- White gutters between panels (8-12px)
- Panels arranged for clear reading flow
- Variety in panel sizes for visual rhythm

### Panel Composition
- Clear focal points in each panel
- Proper use of foreground, midground, background
- Camera angles vary: eye level, bird's eye, low angle, close-up, wide shot
- Action flows logically between panels
- Negative space used intentionally

## Text Elements

### Speech Bubbles
- **Dialogue**: Oval/elliptical bubbles with pointed tails
- White fill with thin black outline
- Tail points clearly to speaker
- Hand-lettered style font (not computer-generated)

### Narrator Boxes
- **Fourth Wall/Narrator**: Rectangular boxes
- Often positioned at panel edges (top or bottom)
- Slightly different fill color (cream or light yellow)
- Used for commentary, time jumps, explanations

### Thought Bubbles
- Cloud-shaped with bubble trail leading to thinker
- Softer outline than speech bubbles
- For internal monologue

### Caption Bars
- Rectangular bars at panel edges
- Time and place information
- "Meanwhile...", "Three years later..." type transitions
- Darker fill with white text, or vice versa

### Typography
- Hand-drawn lettering style throughout
- Bold for emphasis and key terms
- Consistent letter sizing
- Chinese text: use full-width punctuation ""，。！
- Clear hierarchy: titles > dialogue > captions

## Scientific/Concept Visualization

When depicting abstract concepts:

| Concept | Visual Metaphor |
|---------|----------------|
| Neural networks | Glowing nodes connected by clean lines |
| Data flow | Luminous particles along simple paths |
| Algorithms | Geometric patterns, building blocks |
| Logic/proof | Interlocking puzzle pieces |
| Discovery | Light breaking through darkness |
| Uncertainty | Forking paths, question marks |
| Time | Clock motifs, calendar pages |

- Integrate diagrams naturally into narrative panels
- Use inset panels or thought-bubble style for explanations
- Simplified iconography over realistic depiction

## Fourth Wall / Narrator Character

When depicting narrator characters addressing the reader:
- Character may look directly out of panel
- Can appear in "present day" framing scenes
- Distinct visual treatment from main timeline
- Often at page edges or in dedicated panels
- May comment on or question the events shown

## Historical Accuracy

- Research period-specific details: costumes, technology, architecture
- Show aging naturally for characters across time periods
- Iconic items and locations rendered recognizably
- Balance accuracy with stylization

## Language

- All text in Chinese (中文) unless source material is in another language
- Use Chinese full-width punctuation: ""，。！

---

Please generate the comic page based on the content provided below:
