# Visual Elements Library

Icon and symbol vocabulary organized by topic. Use these as building blocks for cover compositions.

## Tech & Development

| Element | Use For |
|---------|---------|
| Code window / Terminal | Programming, development |
| Gear / Cog | Engineering, settings, process |
| Circuit board / Chip | Hardware, AI, computing |
| Binary / Data stream | Data, algorithms |
| API brackets `</>` | Web development, APIs |
| Cloud | Cloud computing, SaaS |
| Lock / Shield | Security, privacy |
| Network nodes | Distributed systems, connections |

## Ideas & Innovation

| Element | Use For |
|---------|---------|
| Lightbulb | Ideas, insights, innovation |
| Rocket | Launch, growth, startups |
| Target / Bullseye | Goals, precision, focus |
| Puzzle piece | Problem solving, integration |
| Key | Solutions, access, unlocking |
| Magnifying glass | Analysis, search, discovery |
| Chart / Graph | Data, trends, growth |
| Arrow / Path | Direction, journey, progress |

## Communication & Collaboration

| Element | Use For |
|---------|---------|
| Speech bubble | Communication, dialogue |
| Chat dots `...` | Conversation, messaging |
| Handshake | Partnership, agreement |
| Team / Figures | Collaboration, community |
| Mail / Envelope | Notifications, outreach |
| Megaphone | Announcements, marketing |
| Network / Web | Social, connections |

## Nature & Growth

| Element | Use For |
|---------|---------|
| Plant / Sprout | Growth, organic, sustainability |
| Tree | Established, structure, branching |
| Leaf | Eco, natural, fresh |
| Sun / Rays | Energy, positivity, new beginnings |
| Mountain | Challenge, achievement, scale |
| Wave | Flow, change, rhythm |
| Seed → Plant | Transformation, potential |

## Tools & Actions

| Element | Use For |
|---------|---------|
| Wrench / Hammer | Building, fixing, tools |
| Pencil / Pen | Writing, creation, editing |
| Brush | Design, creativity, art |
| Scissors | Cutting, editing, trimming |
| Clock / Timer | Time, scheduling, deadlines |
| Calendar | Planning, events, milestones |
| Checklist / Checkbox | Tasks, completion, validation |

## Abstract Concepts

| Element | Use For |
|---------|---------|
| Infinity ∞ | Continuous, endless, loops |
| Yin-yang | Balance, duality, harmony |
| Spiral | Evolution, recursion, cycles |
| Stack / Layers | Depth, hierarchy, structure |
| Bridge | Connection, transition, spanning |
| Door / Portal | Opportunity, entry, access |
| Mirror / Reflection | Self-improvement, analysis |

## Combination Patterns

Create visual metaphors by combining elements:

| Combination | Represents |
|-------------|------------|
| Lightbulb + Gear | Innovative engineering |
| Plant + Code | Organic tech growth |
| Rocket + Target | Precise acceleration |
| Key + Lock | Security solutions |
| Bridge + People | Team connections |
| Magnifier + Data | Analytics, insights |

## Rendering-Specific Treatment

| Rendering | Element Style |
|-----------|---------------|
| `flat-vector` | Geometric, simple shapes, uniform fills |
| `hand-drawn` | Sketchy, organic, doodle-like |
| `painterly` | Soft edges, brush strokes |
| `digital` | Precise, gradient hints, polished |
| `pixel` | 8-bit chunky, grid-aligned |
| `chalk` | Dusty, textured, board style |
