# hierarchical-layers

Nested layers showing levels of importance, influence, or proximity.

## Structure

- Multiple layers from core to periphery
- Core/top: most important/central
- Outer/bottom: decreasing importance
- 3-7 levels typically
- Clear boundaries between levels

## Variants

| Variant | Shape | Visual Emphasis |
|---------|-------|-----------------|
| **Pyramid** | Triangle, vertical | Top-down hierarchy, quantity |
| **Concentric** | Rings, radial | Center-out influence, proximity |

## Best For

- Maslow's hierarchy style concepts
- Priority and importance levels
- Spheres of influence
- Organizational structures
- Stakeholder analysis

## Visual Elements

- Distinct color per level
- Icons or illustrations per tier
- Size indicates importance/quantity
- Labels inside or beside layers
- Decorative apex/center element

## Text Placement

- Title at top or side
- Level names inside each tier
- Brief descriptions outside
- Quantities or percentages if relevant
- Legend for color meanings

## Recommended Pairings

- `craft-handmade`: Playful layered concepts
- `corporate-memphis`: Business hierarchies
- `technical-schematic`: Technical 3D pyramids
