---
name: fresh
category: natural
---

# Fresh Style

Clean, refreshing, natural aesthetic.

## Element Combination

```yaml
canvas:
  ratio: portrait-3-4
  grid: single | triptych

image_effects:
  cutout: soft
  stroke: white-solid | none
  filter: clear-glow | cool-tone

typography:
  decorated: none | highlight
  tags: pill | white-black
  direction: horizontal

decorations:
  emphasis: checkmark | circle-mark
  background: solid-white | solid-pastel
  doodles: leaves | clouds | bubbles
  frames: rounded-rect | none
```

## Color Palette

| Role | Colors | Hex |
|------|--------|-----|
| Primary | Mint green, sky blue, light yellow | #9AE6B4, #90CDF4, #FAF089 |
| Background | Pure white, soft mint | #FFFFFF, #F0FFF4 |
| Accents | Leaf green, water blue | #48BB78, #4299E1 |

## Visual Elements

- Plant leaves, clouds, water drops
- Simple geometric shapes
- Breathing room, open composition
- Natural, organic elements

## Typography

- Clean, light hand lettering with breathing room
- Airy spacing
- Fresh color accents

## Best Layout Pairings

| Layout | Compatibility | Use Case |
|--------|---------------|----------|
| sparse | ✓✓ | Clean covers |
| balanced | ✓✓ | Standard fresh content |
| dense | ✓ | Organized information |
| list | ✓ | Wellness tips |
| comparison | ✓ | Before/after health |
| flow | ✓✓ | Organic processes |

## Best For

- Health and wellness
- Minimalist lifestyle
- Self-care content
- Nature-related topics
- Clean living tips
