---
name: minimal
category: elegant
---

# Minimal Style

Ultra-clean, sophisticated aesthetic.

## Element Combination

```yaml
canvas:
  ratio: portrait-3-4
  grid: single

image_effects:
  cutout: clean
  stroke: none | white-solid
  filter: none | muted-tones

typography:
  decorated: none
  tags: white-black | pill
  direction: horizontal

decorations:
  emphasis: underline | circle-mark
  background: solid-white | solid-pastel
  doodles: hand-drawn-lines
  frames: none | rounded-rect
```

## Color Palette

| Role | Colors | Hex |
|------|--------|-----|
| Primary | Black, white | #000000, #FFFFFF |
| Background | Off-white, pure white | #FAFAFA, #FFFFFF |
| Accents | Single color (content-derived) | Blue, green, or coral |

## Visual Elements

- Single focal point, thin lines
- Maximum whitespace
- Simple, clean decorations
- Restrained visual elements

## Typography

- Clean, simple hand lettering
- Minimal weight variations
- Elegant spacing

## Best Layout Pairings

| Layout | Compatibility | Use Case |
|--------|---------------|----------|
| sparse | ✓✓ | Elegant statements |
| balanced | ✓✓ | Professional content |
| dense | ✓✓ | Clean knowledge cards |
| list | ✓ | Simple lists |
| comparison | ✓ | Clean comparisons |
| flow | ✓ | Elegant processes |

## Best For

- Professional content
- Serious topics
- Elegant presentations
- High-end products
- Business content
