---
name: claude-reflect
description: |
  Execute self-learning system that captures corrections during sessions and syncs them to CLAUDE.md.
  Use when discussing learnings, corrections, or when the user mentions remembering something.
  Trigger with phrases like "remember this", "don't forget", "use X not Y", or "actually...".
allowed-tools: Read, Write, Edit, Bash(jq:*), Bash(cat:*)
version: 1.4.1
license: MIT
author: Bayram Annakov <bayram.annakov@gmail.com>
---

# Claude Reflect - Self-Learning System

A two-stage system that helps Claude Code learn from user corrections.

## How It Works

**Stage 1: Capture (Automatic)**
Hooks detect correction patterns ("no, use X", "actually...", "use X not Y") and queue them to `~/.claude/learnings-queue.json`.

**Stage 2: Process (Manual)**
User runs `/reflect` to review and apply queued learnings to CLAUDE.md files.

## Available Commands

| Command | Purpose |
|---------|---------|
| `/reflect` | Process queued learnings with human review |
| `/reflect --scan-history` | Scan past sessions for missed learnings |
| `/reflect --dry-run` | Preview changes without applying |
| `/skip-reflect` | Discard all queued learnings |
| `/view-queue` | View pending learnings without processing |

## When to Remind Users

Remind users about `/reflect` when:
- They complete a feature or meaningful work unit
- They make corrections you should remember for future sessions
- They explicitly say "remember this" or similar
- Context is about to compact and queue has items

## Correction Detection Patterns

High-confidence corrections:
- Tool rejections (user stops an action with guidance)
- "no, use X" / "don't use Y"
- "actually..." / "I meant..."
- "use X not Y" / "X instead of Y"
- "remember:" (explicit marker)

## CLAUDE.md Destinations

- `~/.claude/CLAUDE.md` - Global learnings (model names, general patterns)
- `./CLAUDE.md` - Project-specific learnings (conventions, tools, structure)

## Example Interaction

```
User: no, use gpt-5.1 not gpt-5 for reasoning tasks
Claude: Got it, I'll use gpt-5.1 for reasoning tasks.

[Hook captures this correction to queue]

User: /reflect
Claude: Found 1 learning queued. "Use gpt-5.1 for reasoning tasks"
        Scope: global
        Apply to ~/.claude/CLAUDE.md? [y/n]
```
