<overview>

Common mistakes when interpreting Culture Index profiles. Avoiding these errors is as important as understanding the methodology itself.

</overview>

<interpretation_mistakes>

<mistake name="comparing-absolutes">

**Comparing absolute trait values between people**

**Wrong:** "Dan has higher autonomy than Jim because his A is 8 vs 5"

**Right:** "Dan is +3 centiles from his arrow; Jim is +1 from his arrow"

**Why it's wrong:** The arrow position varies between surveys based on EU. An 8 with an arrow at 6 is only +2 from norm. A 5 with an arrow at 2 is +3 from norm.

**Only exception:** L and I use absolute values and CAN be compared directly.

</mistake>

<mistake name="ignoring-arrow">

**Ignoring the red arrow position**

The arrow is the population mean (50th percentile). All interpretation must be relative to it.

**Wrong:** "This person has low B (score of 3)"

**Right:** "This person's B is 2 centiles left of their arrow, indicating pronounced introversion"

</mistake>

<mistake name="value-judgments">

**Treating traits as "good" or "bad"**

Culture Index measures behavioral traits, not value or capability.

**Wrong:**
- "High D is good because they're detail-oriented"
- "Low B is bad because they're not social"

**Right:**
- "High D indicates strong attention to detail - fits roles requiring precision"
- "Low B indicates preference for focused work - fits analytical roles"

There is no universally "good" profile. Fit depends on role, team, and context.

</mistake>

<mistake name="stale-data">

**Using outdated data (18+ months old)**

Job behaviors update as environment, leadership, or projects change. Stale data leads to wrong conclusions.

**Best practice:** Resurvey job behaviors every 6 months, especially after major role or leadership changes.

</mistake>

<mistake name="single-trait-focus">

**Over-indexing on a single trait**

The pattern (relationship between traits) matters more than any individual dot.

**Wrong:** "They have High A, so they're a leader"

**Right:** "High A combined with High D suggests they can build new systems. High A with Low D suggests they'll drive fast but may miss details."

</mistake>

<mistake name="ignoring-survey-vs-job">

**Not comparing Survey vs Job graphs**

Missing burnout signals by only looking at one graph.

**Always check:**
- Did the arrow move? (Stress/Frustration signal)
- Did any dots flip sides? (Polarizing shift - flight risk)
- What's the EU utilization? (>130% stress, <70% frustration)

</mistake>

<mistake name="confusing-traits-behaviors">

**Confusing traits with behaviors**

Survey (top) = hardwired traits (who you ARE)
Job (bottom) = adaptive behaviors (who you're TRYING TO BE)

Traits don't change. Behaviors can be modified temporarily - but at an energy cost.

**"You can't send a duck to Eagle school."** - You can train behaviors, not traits.

</mistake>

</interpretation_mistakes>

<application_mistakes>

<mistake name="seeking-homogeneity">

**Hiring for homogeneous teams**

Hiring people who match the manager's profile creates blind spots.

**Better approach:** Build diverse teams with complementary traits. Every team needs Gas (High A), Brake (High D), and Glue (High B) in appropriate proportions.

</mistake>

<mistake name="overloading-high-a">

**Overloading on High A's**

High A's are "the single hardest trait to employ." They work for "me, Inc." first.

Too many High A's = power struggles, lack of follow-through, no one to execute.

**You are only RENTING High A's** - they need a mutually beneficial partnership.

</mistake>

<mistake name="neglecting-brake">

**Neglecting the Brake (High D)**

Every team needs quality control, risk management, and follow-through.

Without Brake: Erosion, mistakes, lawsuits, quality issues, things start but never finish.

</mistake>

<mistake name="assuming-fit-permanent">

**Assuming job fit is permanent**

People's roles evolve. Business needs change. What fit yesterday may not fit tomorrow.

Regular check-ins (resurvey every 6 months) catch misalignment before it becomes burnout or turnover.

</mistake>

<mistake name="using-ci-alone">

**Using Culture Index as the only data point**

Culture Index is ONE tool among many. It measures behavioral traits, not:
- Skills or competencies
- Intelligence
- Experience
- Values
- Motivation

**Best practice:** Use CI alongside interviews, references, skills assessments, and performance data.

</mistake>

</application_mistakes>

<communication_mistakes>

<mistake name="sharing-raw-scores">

**Sharing raw scores without context**

Telling someone "Your A is 8" without explaining relative position is meaningless and potentially harmful.

**Always communicate:**
- Position relative to arrow
- What that means behaviorally
- Why it's neither good nor bad
- How it fits (or doesn't) with their role

</mistake>

<mistake name="labeling-people">

**Using CI to label or box people**

CI shows tendencies, not destiny.

**Wrong:** "You're a Persuader, so you should only do sales"

**Right:** "Your pattern shows strengths in influence and relationship building. How do you use those in your current role?"

</mistake>

<mistake name="public-comparison">

**Comparing profiles publicly**

Never compare individuals' profiles in group settings without their consent.

Discussing "Person A is more detail-oriented than Person B" creates hierarchy and judgment.

</mistake>

</communication_mistakes>

<red_flags>

**Signals that suggest deeper investigation:**

| Signal | What to Check |
|--------|---------------|
| EU 0-10 (avoidant response) | Was survey completed properly? Trust issues? |
| All dots on or near arrow | Chameleon pattern - less than 0.57% of population. Verify validity. |
| Job behaviors completely opposite of Survey | Imminent flight risk. What's causing this extreme modification? |
| EU utilization > 150% | Severe stress. Immediate conversation needed. |
| EU utilization < 50% | Severe disengagement. May have already mentally quit. |
| D raised significantly in Job behaviors | Most common unsustainable stress pattern. Why do they feel they need to be so much more perfectionist? |

</red_flags>

<checklist>

**Before finalizing any interpretation:**

- [ ] Did I use relative positions (distance from arrow)?
- [ ] Did I avoid calling any trait "good" or "bad"?
- [ ] Did I compare Survey vs Job if both available?
- [ ] Did I calculate EU utilization?
- [ ] Did I consider the full pattern, not just leading traits?
- [ ] Is my data current (less than 18 months old)?
- [ ] Did I note that CI is one data point among many?

</checklist>

<rationalization_table>

**Common excuses that indicate you're about to make a CI interpretation mistake:**

| Excuse | Reality |
|--------|---------|
| "Their A is higher so they're more autonomous" | Compare distance from arrow, not absolute values |
| "This is a bad profile for leadership" | No bad profiles - fit depends on role and context |
| "They need to change their C trait" | Survey traits are hardwired - change the environment instead |
| "Low B means they're not a team player" | Low B means they prefer focused work - they can still collaborate |
| "High D is always good for quality" | High D without other traits can mean paralysis and rigidity |
| "They should be more like their manager" | Different profiles bring complementary strengths |
| "This pattern can't do that job" | Patterns indicate tendencies, not hard limits |
| "Their EU is fine, the job is the problem" | EU tells you about energy, not about job design |
| "I remember their profile from last year" | Resurvey Job behaviors every 6 months - they change |
| "The arrow doesn't matter, just look at the dots" | The arrow IS the reference point - dots mean nothing without it |
| "L and I work the same as A, B, C, D" | L and I use absolute values, primary traits are relative |
| "Survey and Job will be the same" | Survey = hardwired, Job = adaptive. They often differ. |
| "High A means they're selfish" | High A means they're self-directed - not the same thing |
| "We need all High A's on this high-growth team" | You're renting High A's, and they'll clash with each other |
| "This hire looks good, skip the CI" | CI is one data point - use it WITH other assessments, not instead of |

</rationalization_table>
