<overview>

This reference helps predict Culture Index traits from interview transcripts. Candidates don't take CI during interviews - these signals help estimate traits before the actual survey is administered after an offer is signed.

**Important caveats:**
- Predictions are estimates, not definitive assessments
- Interview context affects behavior (stress, performance mode)
- Always note confidence level for each trait
- Actual CI survey will confirm or correct predictions

</overview>

<trait_signals>

<autonomy_a label="Autonomy (A) Signals">

**High A indicators (right of arrow):**
- Uses "I" frequently: "I decided...", "I built...", "I led..."
- Takes personal credit for outcomes
- Describes situations where they acted independently
- Pushes back on interviewer questions or reframes them
- Strategic framing - connects work to business outcomes
- Confident tone, assertive statements
- Mentions enjoying autonomy, disliking micromanagement
- Describes taking initiative without being asked

**Low A indicators (left of arrow):**
- Uses "we" predominantly: "We decided...", "Our team..."
- Deflects credit to the team
- Asks clarifying questions before answering
- Seeks validation: "Does that make sense?"
- Describes collaborative decision-making
- Mentions appreciating clear direction
- More tentative language: "I think...", "Maybe..."
- Waits for prompts rather than driving conversation

**Confidence modifiers:**
- HIGH confidence: Multiple consistent signals across different questions
- MEDIUM confidence: Mixed signals or few data points
- LOW confidence: Signals only in specific contexts (may be performance mode)

</autonomy_a>

<social_b label="Social Ability (B) Signals">

**High B indicators (right of arrow):**
- Builds rapport quickly, asks about interviewer
- Animated, expressive communication style
- Tells stories with people as central characters
- Discusses team dynamics, relationships
- Uses humor, creates connection
- Mentions enjoying collaboration, team activities
- Verbose responses, talks through thinking
- Mirrors interviewer's energy and style

**Low B indicators (left of arrow):**
- Brief, direct answers without elaboration
- Skips small talk, gets to the point
- Task-focused: describes what was done, not who was involved
- Reserved or flat affect
- Minimal questions about the team/culture
- Doesn't engage with personal questions
- Processes internally before responding
- Technical precision over narrative style

**Confidence modifiers:**
- HIGH confidence: Behavior consistent throughout entire interview
- MEDIUM confidence: Opens up later (may be warming up)
- LOW confidence: Interviewer-driven variation (some interviewers draw out B)

</social_b>

<pace_c label="Pace/Patience (C) Signals">

**High C indicators (right of arrow):**
- Thoughtful pauses before answering
- Asks for clarification, wants to understand fully
- Structured, methodical responses
- Mentions preferring stable environments
- Describes careful, deliberate decision-making
- Discomfort with hypotheticals or rapid-fire questions
- References to planning, preparation
- Prefers one topic at a time

**Low C indicators (left of arrow):**
- Rapid responses, quick wit
- Interrupts or finishes interviewer's sentences
- Topic-jumps, tangential connections
- Mentions thriving under pressure, deadlines
- Comfortable with ambiguity and pivots
- Describes multitasking positively
- Energy increases with urgency
- Short attention span for detailed questions

**Confidence modifiers:**
- HIGH confidence: Consistent pace throughout interview
- MEDIUM confidence: Interview pressure may affect natural pace
- LOW confidence: Phone vs in-person may show different C

</pace_c>

<conformity_d label="Conformity/Detail (D) Signals">

**High D indicators (right of arrow):**
- Precise language, specific numbers and dates
- References rules, processes, best practices
- Structured answers following question format
- Mentions quality, accuracy, standards
- Asks about company processes, documentation
- Describes checking work, seeking feedback
- Uses technical terms correctly and consistently
- Follows interview structure carefully

**Low D indicators (left of arrow):**
- Big-picture answers, approximations
- Comfortable with "it depends" responses
- Creative interpretations of questions
- Mentions flexibility, adaptability
- Skeptical of rigid processes
- Focuses on outcomes over methods
- May challenge question premises
- Unstructured, flowing responses

**Confidence modifiers:**
- HIGH confidence: Consistent precision (or lack of) across topics
- MEDIUM confidence: Higher precision in domain expertise areas
- LOW confidence: May mask natural D to appear more flexible

</conformity_d>

<logic_l label="Logic (L) Signals">

Note: L uses absolute values (not relative to arrow).

**High L indicators (7-10):**
- Data-driven reasoning: "The numbers showed..."
- Logical frameworks: "First... then... therefore..."
- Emotion-neutral language
- Focuses on facts over feelings
- Analytical approach to problems
- May seem detached when discussing difficult situations
- Questions based on data or evidence

**Low L indicators (0-3):**
- Values-driven language: "It felt right..."
- Emotional context in stories
- Empathy-focused responses
- Describes gut feelings, intuition
- People-impact framing
- May get emotional discussing meaningful work
- Questions based on culture, values, impact

**Moderate L (4-6):**
- Blends logic and emotion contextually
- Adapts framing to situation
- Can argue both sides

</logic_l>

<ingenuity_i label="Ingenuity (I) Signals">

Note: I uses absolute values (not relative to arrow).

**High I indicators (7-10):**
- Novel approaches to problems
- Questions assumptions, challenges status quo
- Connects unrelated concepts
- Describes inventing solutions
- Mentions boredom with routine
- Creative reframing of questions
- Original examples, not textbook answers

**Low I indicators (0-3):**
- Conventional approaches, proven methods
- References industry standards, best practices
- Prefers established processes
- Practical, grounded solutions
- Describes following playbooks successfully
- May seem less creative but highly reliable

**Moderate I (4-6):**
- Creative within constraints
- Innovates when necessary, follows when appropriate

</ingenuity_i>

</trait_signals>

<pattern_combinations>

Look for trait combinations that suggest patterns:

| Signal Cluster | Likely Pattern |
|----------------|----------------|
| High A + Low B + rapid pace + big-picture | Architect/Visionary |
| High A + High B + rapid pace | Rainmaker/Persuader |
| Low B + deliberate pace + precise | Scholar/Specialist |
| Low A + High B + deliberate | Accommodator |
| Low A + Low B + precise | Technical Expert |

</pattern_combinations>

<transcript_analysis_tips>

**When analyzing transcripts:**

1. **Count language patterns** - "I" vs "we", precise vs approximate
2. **Note energy shifts** - What topics animate them? What topics flatten them?
3. **Watch for consistency** - Same signals across different questions?
4. **Consider context** - Technical questions vs behavioral questions
5. **Flag uncertainties** - Note where evidence is weak

**Red flags for confidence:**
- Candidate clearly in "interview mode" (performing)
- Very short interview (insufficient data)
- Interviewer dominated conversation
- Technical-only questions (limited behavioral data)

</transcript_analysis_tips>

<output_format>

When predicting traits from transcripts, output:

```
## Predicted Culture Index Profile: [Candidate Name]

### Trait Predictions
| Trait | Predicted Position | Confidence | Key Evidence |
|-------|-------------------|------------|--------------|
| A | High/Low/Norm | H/M/L | "Quote..." |
| B | High/Low/Norm | H/M/L | "Quote..." |
| C | High/Low/Norm | H/M/L | "Quote..." |
| D | High/Low/Norm | H/M/L | "Quote..." |
| L | Score (0-10) | H/M/L | "Quote..." |
| I | Score (0-10) | H/M/L | "Quote..." |

### Predicted Pattern
[Pattern name] - [Confidence]

### Evidence Summary
[2-3 sentences on strongest signals]

### Uncertainty Areas
[Where more data would help]

### Caveats
- Interview behavior may differ from natural behavior
- Actual CI survey will be administered after offer
- This prediction is a hypothesis, not a diagnosis
```

</output_format>
