<overview>

The simplest way to drive engagement and productivity is to find the leading dot among A, B, D (the three confidence traits) and install motivators for that trait consistently.

</overview>

<motivator_framework>

**Step 1: Find the leading dot** between A, B, and D (the three confidence traits)
**Step 2: Go to that trait's motivator box** (see below)
**Step 3: Install 3-4 of those motivators consistently**

**When dots are stacked** (three confidence traits close together): D always wins - start with D trait motivators first, then B, then A.

**Master level:** Hit motivators for all four primary dots. Takes 2-3 years of practice.

**Retention tip:** Expect to retain ~30% of workshop content initially. Quarterly team discussions with real-life examples help mobilize learning.

</motivator_framework>

<motivators_by_trait>

<high_a label="High Autonomy Motivators">

- **Variable compensation** - Bonus, equity, commission over fixed salary
- **Autonomy** - Freedom to decide how to achieve goals
- **ROI-focused communication** - Bullet points, not walls of text
- **Outcomes over process** - "Bake me a cake" not "here's the recipe"
- **Challenge** - Opportunities to compete and win
- **Buy-in through questions** - Let them "own" the idea
- **Respect their time** - Don't waste it with unnecessary meetings

**What doesn't work:** Micromanagement, detailed instructions, fixed salary only, consensus-driven decisions

</high_a>

<low_a label="Low Autonomy Motivators">

- **Specific praise** - "Great job on the Johnson proposal" not "Great job"
- **Consistent compensation** - Predictable over variable bonuses
- **Clear frameworks** - For novel decisions
- **Direction before action** - Don't expect self-initiation
- **Team recognition** - Acknowledge collaborative contributions
- **Safety to disagree** - Probe for true concerns (they won't volunteer)

**What doesn't work:** Variable compensation, ambiguous direction, expecting initiative on new challenges

</low_a>

<high_b label="High Social Motivators">

- **Words of affirmation** - Primary currency - verbal praise, public recognition
- **Small talk time** - Not wasted time, it's relationship investment
- **Group activities** - Include them in social events
- **People interaction** - Don't isolate with solo work
- **Public recognition** - Acknowledge in team settings
- **Relationship building time** - Before getting to tasks

**What doesn't work:** Solo work for extended periods, skipping small talk, private-only recognition, purely transactional relationships

</high_b>

<low_b label="Low Social Motivators">

- **Leave them alone** - Minimize unnecessary check-ins
- **Written communication** - Email/async over meetings
- **Private recognition** - Public praise is uncomfortable
- **Thoughtful gifts** - A useful book means more than "great job"
- **Quality 1:1 time** - Meaningful conversations over group settings
- **Focus time protection** - No unnecessary interruptions

**What doesn't work:** Frequent check-ins, group meetings, public praise, forced social events

</low_b>

<high_c label="High Patience Motivators">

- **Advance notice** - Of changes, meetings, new projects
- **Meeting agendas** - Sent in advance, no surprises
- **One topic per meeting** - Multi-topic meetings are stressful
- **Protected focus time** - Shield from interruptions
- **Predictable schedules** - Same routine, same environment
- **Written checklists** - Structured approaches to follow
- **28-minute rule** - Respect their recovery time after interruptions

**What doesn't work:** Last-minute changes, frequent pivots, multi-topic meetings, constant interruptions

</high_c>

<low_c label="Low Patience Motivators">

- **Variety** - Keep them busy, load them up
- **Changing environments** - Thrive in consistent pivots
- **Movement** - Mental or physical in their day
- **Fires to fight** - Creative problems to solve
- **DEADLINES** - Critical motivator - put in email subject lines
- **Multiple projects** - Allow switching between tasks
- **Quick wins** - Short-term goals they can complete fast

**What doesn't work:** Monotony, long-term projects without milestones, no deadlines, forced focus on single tasks

</low_c>

<high_d label="High Conformity Motivators">

- **Don't make it personal** - Frame as process improvement, not personal failure (they're already wearing it)
- **Training opportunities** - The currency is knowledge (conferences, CEUs, certifications)
- **Structured environment** - Accountable, with enforced standards
- **Recognition when deserved** - But ONLY if deserved. Don't compliment if it's not great; they know.
- **Fair, justified pay** - Based on education, experience, market rates - give them the details
- **Trust** - Huge word for high Ds. Don't break it.
- **SOPs and documentation** - Railroad tracks to stay on

**What doesn't work:** Personal criticism, unearned praise, arbitrary decisions, broken commitments, chaotic environments

</high_d>

<low_d label="Low Conformity Motivators">

- **Creative problems** - Give them something to figure out
- **Room to run** - Freedom from too much structure and rules
- **Options** - Don't box them in, offer choices
- **Pick your battles** - Focus on the 3 things that financially move the needle
- **Big picture focus** - Don't drown in details
- **Innovation opportunities** - Space to experiment

**What doesn't work:** Too many rules, excessive structure, detail-heavy work, micromanagement, rigid processes

</low_d>

</motivators_by_trait>

<communication_styles>

| Trait | Communication Approach |
|-------|------------------------|
| High A | Bullet points, ROI focus, outcomes not process, let them "own" ideas |
| Low A | Clear direction, specific feedback, collaborative framing |
| High B | Build relationship first, verbal processing time, public recognition |
| Low B | Written communication, private recognition, respect their processing time |
| High C | Advance notice, agendas, one topic at a time, protect focus |
| Low C | Deadlines in subject line, variety, quick transitions |
| High D | Data and details, justify decisions, earn trust, don't make personal |
| Low D | Big picture first, options, creative framing |

</communication_styles>

<confidence_recovery>

When someone's confidence is shaken, recovery method depends on their leading confidence trait:

| Confidence Source | Recovery Strategy |
|-------------------|-------------------|
| High A (Inner self-confidence) | Stack easy wins - get back in the winner's circle |
| High B (Social confidence) | Relationship reconnection - rebuild social bonds |
| High D (Knowledge confidence) | Acquire more knowledge - training, certifications |

</confidence_recovery>
