<overview>

Culture Index identifies 19 distinct behavioral patterns based on the configuration of A, B, C, D traits. The interaction between traits reveals more than individual positions.

</overview>

<common_archetypes>

| Archetype | Pattern | Description | Typical Roles |
|-----------|---------|-------------|---------------|
| Visionary/Architect | High A, Low C, Low D | Big-picture, fast-paced, dislikes details. Best system builders when also high D. | CEO, Entrepreneur, Founder |
| Rainmaker/Persuader | High A, High B, Low C | Aggressive, charming, fast. Closes deals, builds relationships. | Sales Hunter, BD, Account Executive |
| Scholar/Specialist | Low B, High C, High D | Introverted, patient, detail-oriented. Deep expertise. | Engineer, CFO, Analyst |
| Accommodator | Low A, High B, High C | Team player, patient, people-focused. Service orientation. | HR, Customer Success |
| Debater | High B, Low A, Low D | Charming, non-conforming, unfiltered. Good storyteller. | Sales (relationship), Creative |
| Technical Expert | Low A, Low B, Low C, High D | Efficient specialists. Fast-moving detail people. | Security, QC, Ops |
| Craftsman | Low A, Low B, High C, High D | Patient, precise executors. Expert taskmasters. | Finance, Compliance |
| Socializer | Low A, High B, High C, Low D | Go along, get along. Team-focused, people-focused, slowing down. | Support, HR |
| Philosopher | High A, Low B, High C | Patient, analytical thinkers. Independent contemplation. | Strategy, Research |
| Administrator | Moderate across traits | Versatile generalists. Can adapt to many situations. | Operations, General Management |

</common_archetypes>

<trait_combinations>

Notable combinations and their implications:

| Combination | Name | Behavior |
|-------------|------|----------|
| High A + Low D | **Greatest Risk Takers** | Aggressive risk-taker without brakes. Gas pedal only. Most independent people (two types of independence combined). |
| Low A + High D | **Most Risk Averse** | Conservative, careful, will never cut corners. Bottom-line protectors. |
| Low A + High B | Collaborative Leader | Servant leadership, great team builder, may avoid necessary conflict |
| Low B + High C | "Leave Me Alone x2" | Strongly prefers solitary, focused work. Double introversion signal. |
| High B + Low C | Verbal Sprayer | Talks fast, often, many topics. Processing out loud rapidly. |
| High A + Low B | Results Driver | Drives results without regard for feelings. May seem low EQ. |
| High D + Low A | Perfectionist Follower | Executes exactly as instructed, never cuts corners. Good at optimizing existing processes. |
| High A + High D | Process Builder | Forward-thinking AND detail-oriented. Can build NEW systems and processes. (Architects, Scholars, Technical Experts) |
| Low C + Low D | Double Error Risk | Moving fast (Low C) + not checking work (Low D) = high error rate. Needs systems to catch mistakes. |
| Low C + High D | Wound Tight | Impatient AND perfectionist. High strung, worrisome, feels everything is urgent and must be perfect. |

</trait_combinations>

<task_vs_people>

A vs B determines task vs people orientation:

| Pattern | Meaning |
|---------|---------|
| A > B | Values tasks over people; will push through to get results |
| B > A | Values people over tasks; prioritizes harmony and relationships |

</task_vs_people>

<strategic_cross>

**Low C + Low D = "Maverick" or "Change Agent"**

- Fast-moving (Low C) and unconcerned with rules (Low D)
- Natural agents of change and innovation
- May cause disruption
- Good for turnarounds, startups, transformations

</strategic_cross>

<technical_stack>

**High C + High D = "Specialist" or "Operator"**

- Patient (High C) and precise (High D)
- Will ensure work is done correctly, won't rush
- May resist change
- Good for compliance, quality, operations

</technical_stack>

<chameleon_pattern>

**All four primary dots near the arrow = "Chameleon"**

- Statistically average across all traits
- Unpublished pattern making up less than 0.57% of population
- Maximum flexibility but may lack strong, predictable drivers
- Hard to pin down - adapts to situations

</chameleon_pattern>

<pattern_width>

The spread between traits matters as much as individual positions.

**Wide pattern** (traits spread far apart):
- More extreme, predictable behaviors
- Stronger drivers
- Easier to predict day-to-day behavior

**Narrow pattern** (traits clustered):
- More moderate, flexible behaviors
- Less predictable
- Can adapt to situations

Two people can have identical A positions but vastly different overall patterns due to B/C/D spread.

</pattern_width>

<pattern_fit_warning>

**Flight risk signal**: When someone's Job behaviors show the opposite of their Survey traits.

Example: Architect pattern (High A, Low C, Low D) → Socializer in job (Low A, High B, High C, Low D)
- All dots flipped to opposite side
- This is imminent flight risk
- Something must change or they will leave

</pattern_fit_warning>

<role_fit_questions>

When determining what pattern fits a role, ask:

| Question | Left Answer | Right Answer | Relevant Trait |
|----------|-------------|--------------|----------------|
| Is this role more **macro** or **micro**? | Micro (details, execution) | Macro (big picture, strategy) | A trait |
| Is this position more about **people skills** or **problem solving**? | Problem solving | People skills | B trait |
| How much **repetition** is in this role? | Low repetition, chaos, variety | High repetition, stability, predictable | C trait |

**Use these to match patterns:**
- Macro + people + variety = High A, High B, Low C (Rainmaker/Persuader)
- Micro + problem solving + stability = Low A, Low B, High C, High D (Craftsman/Specialist)
- Macro + problem solving + stability = High A, Low B, High C, High D (Scholar/Architect)

</role_fit_questions>

<identifying_pattern>

**Quick interpretation method:**

1. Find the farthest dot from the normative line (highest deviation)
2. Identify which range it falls into:
   - ±2 centiles = "somewhat" or "very" (one standard deviation)
   - ±4 centiles = "extremely" (entering six-sigma territory)
3. Use word descriptors from the appropriate column

**Example**: D trait is 4.5 centiles right of the norm = "extremely conforming perfectionist, precise, cautious, accurate."

**For dots on or near the line** (±0.5): "Situationally, depending on your level of comfort and experience, you might be [right-side words] or [left-side words]."

</identifying_pattern>
