<overview>

Every team needs the right mix of Gas, Brake, and Glue for its current needs. The ratio depends on the season of business, the function, and current gaps.

</overview>

<gas_brake_glue>

| Role | Trait | Function | Too Little | Too Much |
|------|-------|----------|------------|----------|
| **Gas Pedal** | High A | Growth, risk-taking, innovation, driving results | Stagnation, waiting around, no decisive action | Chaos, recklessness, burnout |
| **Brake Pedal** | High D | Risk aversion, quality control, compliance, finishing | Erosion, mistakes, lawsuits, quality issues | Paralysis, perfectionism, can't ship |
| **Glue** | High B | Relationships, morale, optimism, "fun part of the zoo" | Root canal culture, morale problems, no fun | All talk, no action, groupthink |

</gas_brake_glue>

<diagnostic_questions>

| Symptom | Likely Gap |
|---------|------------|
| Lacking growth, decisive action, or strategic problem-solving | Not enough high A (Gas) |
| Morale sucks, culture feels like a root canal, no fun | Not enough high B (Glue) |
| Quality erosion, mistakes, compliance issues | Not enough high D (Brake) |
| Chaos, recklessness, burnout, no follow-through | Too much Gas, not enough Brake |
| Paralysis, perfectionism, can't ship anything | Too much Brake, not enough Gas |
| All talk, no action, groupthink, avoiding hard decisions | Too much Glue, not enough Gas |

</diagnostic_questions>

<business_season>

The ideal balance depends on what the team/company needs now:

| Season | Priority | What You Need |
|--------|----------|---------------|
| **High-growth / Turnaround** | Gas | Drivers and risk-takers. High A's who will push through. |
| **Consolidation / Stability** | Brake | Quality and consistency. High D's who ensure nothing breaks. |
| **Culture Building** | Glue | Relationship builders. High B's who create positive environment. |
| **Complex Operations** | Brake + Glue | Precision and collaboration. Need both quality control and team cohesion. |
| **Innovation / R&D** | Gas + Low D | Risk-takers who experiment. High A + Low D = willingness to fail fast. |
| **Compliance-Heavy** | Brake | High D's who follow rules precisely. Risk aversion is a feature. |

</business_season>

<function_needs>

Different functions naturally need different balances:

| Function | Primary Need | Why |
|----------|-------------|-----|
| Sales | Gas (High A) | Drive results, close deals, push through objections |
| Engineering | Brake (High D) | Quality code, attention to detail, systematic approach |
| Customer Success | Glue (High B) | Relationships, retention, advocacy |
| Operations | Brake (High D) | Consistency, reliability, process adherence |
| Marketing (Creative) | Gas + Low D | Innovation, experimentation, bold ideas |
| Finance | Brake (High D) | Accuracy, compliance, risk management |
| HR | Glue (High B) | Culture, relationships, employee advocacy |
| Executive Team | Balanced | Need all three: drive (Gas), quality (Brake), culture (Glue) |

</function_needs>

<c_trait_team_impact>

C (Pace/Patience) affects team dynamics beyond Gas/Brake/Glue:

| Team Pattern | Implication |
|--------------|-------------|
| Mostly Low C | Fast-moving, urgent, may create unnecessary chaos. Need someone to slow things down occasionally. |
| Mostly High C | Steady, patient, but may resist change. Need someone to push urgency when required. |
| Mixed C | Natural tension between fast and slow movers. Can be healthy friction if managed. |

**Considerations:**
- If major projects require urgent pivots → need some Low C
- If major projects require sustained focus → need some High C
- Pairing Low C with High C can create complementary partnerships (one pushes, one steadies)

</c_trait_team_impact>

<a_vs_b_team_balance>

Team-wide task vs people orientation:

| Pattern | Implication |
|---------|-------------|
| A > B (most people) | Task-focused, results-driven. May neglect relationships and culture. Risk of burnout and turnover. |
| B > A (most people) | People-focused, harmonious. May avoid tough decisions and underperform on results. |
| Mixed A/B | Healthy tension. Task drivers balanced by relationship builders. |

</a_vs_b_team_balance>

<hiring_to_fill_gaps>

When hiring to fill a gap, specify the ideal profile:

**Gap: Not enough Gas**
```
Ideal Hire Pattern:
- A: High (right of arrow) - drives results, takes initiative
- B: Any (based on role) - depends on whether role is people-facing
- C: Low preferred - urgency and pace
- D: Any (consider existing Brake capacity)
```

**Gap: Not enough Brake**
```
Ideal Hire Pattern:
- A: Any - Low A + High D = specialist optimizer
- B: Any (based on role)
- C: High preferred - patience for detailed work
- D: High (right of arrow) - quality focus, follow-through
```

**Gap: Not enough Glue**
```
Ideal Hire Pattern:
- A: Any - Low A + High B = collaborative culture builder
- B: High (right of arrow) - relationship builder
- C: Any (based on role pace)
- D: Any
```

</hiring_to_fill_gaps>

<conflict_pairs>

Trait combinations that create friction on teams:

| Combination | Friction Point | Mitigation |
|-------------|----------------|------------|
| High A vs High A | Power struggles, both want to lead | Clear role delineation, separate domains |
| High A vs Low A | Independence vs collaboration | High A provides direction, respects Low A's process |
| High B vs Low B | Social needs mismatch | High B allows Low B alone time; Low B participates minimally |
| High C vs Low C | Pace/urgency mismatch | Low C respects focus time; High C accepts some urgency |
| High D vs Low D | Detail orientation clash | High D accepts "good enough"; Low D follows through |
| High D vs High D | Both perfectionist, both critical | Can be excellent partnership if aligned on standards |

</conflict_pairs>

<remote_team_considerations>

For remote/distributed teams:

- **Glue is even more critical** - Without casual office interactions, High B's are essential for maintaining culture
- **Low B's thrive** - Remote work is natural for those who prefer isolation
- **Low C's may struggle** - Harder to get immediate responses, may feel urgency isn't matched
- **High D's need clear processes** - More documentation, explicit SOPs for remote work

</remote_team_considerations>
