<required_reading>

**Read these reference files before analyzing:**
1. `references/team-composition.md` - Gas/Brake/Glue framework
2. `references/patterns-archetypes.md` - Pattern identification

</required_reading>

<process>

**Step 1: Load All Team Profiles**

Gather profiles for all team members. For each person, you need:
- Name
- Pattern/Archetype
- Trait distances from arrow (A, B, C, D)
- EU values (Survey and Job)

**Step 2: Categorize Gas/Brake/Glue**

For each team member, identify their primary role:

| Role | Trait | Who Qualifies |
|------|-------|---------------|
| **Gas** | High A (right of arrow) | Drives growth, takes risks, initiates |
| **Brake** | High D (right of arrow) | Controls quality, manages risk, finishes |
| **Glue** | High B (right of arrow) | Builds culture, maintains morale, connects |

Create a team roster:

| Name | Pattern | Primary Role | Secondary Role |
|------|---------|--------------|----------------|
| ? | ? | Gas/Brake/Glue | ? |

**Step 3: Assess Balance**

Count roles:
- Gas (High A): [X] people
- Brake (High D): [X] people
- Glue (High B): [X] people

**Balance indicators:**

| Symptom | Likely Gap |
|---------|------------|
| Lacking growth, decisive action, strategic problem-solving | Not enough Gas (High A) |
| Morale issues, root canal culture, no fun | Not enough Glue (High B) |
| Quality erosion, mistakes, compliance issues | Not enough Brake (High D) |
| Chaos, recklessness, burnout | Too much Gas, not enough Brake |
| Paralysis, perfectionism, can't ship | Too much Brake, not enough Gas |
| All talk, no action, groupthink | Too much Glue, not enough Gas |

**Step 4: Consider Business Season**

The ideal balance depends on what the team/company needs now:

| Season | Priority | Emphasis |
|--------|----------|----------|
| High-growth / Turnaround | Gas | Need drivers and risk-takers |
| Consolidation / Stability | Brake | Need quality and consistency |
| Culture Building | Glue | Need relationship builders |
| Complex Operations | Brake + Glue | Need precision and collaboration |

**Step 5: Identify Gaps**

Based on balance assessment:

```
Current State:
- Gas: [X] (sufficient/insufficient)
- Brake: [X] (sufficient/insufficient)
- Glue: [X] (sufficient/insufficient)

Gap Analysis:
- [Gap 1]: [Description and impact]
- [Gap 2]: [Description and impact]
```

**Step 6: Check C Trait Distribution**

C (Pace/Patience) affects team dynamics:

| Pattern | Implication |
|---------|-------------|
| Mostly Low C | Fast-moving, urgent, may create chaos |
| Mostly High C | Steady, patient, may resist change |
| Mixed C | Natural tension between fast and slow |

If major projects require urgent pivots → need some Low C.
If major projects require sustained focus → need some High C.

**Step 7: Review A vs B Balance**

Team-wide task vs people orientation:

| Pattern | Implication |
|---------|-------------|
| A > B (most people) | Task-focused, results-driven, may neglect relationships |
| B > A (most people) | People-focused, harmonious, may avoid tough decisions |
| Mixed | Healthy tension, can balance both |

**Step 8: Flag Potential Conflicts**

Trait combinations that create friction:

| Combination | Friction Point |
|-------------|----------------|
| High A vs Low A | Independence vs collaboration expectations |
| High B vs Low B | Social needs mismatch |
| High C vs Low C | Pace/urgency mismatch |
| High D vs Low D | Detail orientation mismatch |

Identify specific pairs who may clash.

**Step 9: Recommend Hires (if gaps exist)**

For each gap, specify ideal profile:

```
Gap: [Missing role]
Ideal Hire: [Pattern type]
- A: [high/low/normative] - [reason]
- B: [high/low/normative] - [reason]
- C: [high/low/normative] - [reason]
- D: [high/low/normative] - [reason]
```

**Step 10: Compile Team Analysis**

```
## Team Composition Analysis

### Team Roster
[Table of members with patterns and roles]

### Balance Assessment
- Gas (High A): [count] - [assessment]
- Brake (High D): [count] - [assessment]
- Glue (High B): [count] - [assessment]

### Current Gaps
1. [Gap and impact]
2. [Gap and impact]

### Potential Friction Points
- [Person A] vs [Person B]: [reason]

### Hiring Recommendations
1. [Role needed]: [Pattern to seek]

### Team Strengths
1. [Strength 1]
2. [Strength 2]

### Watch Areas
1. [Risk 1]
2. [Risk 2]
```

</process>

<anti_patterns>

Avoid these team analysis mistakes:

- **Seeking homogeneity**: Teams need diverse profiles, not clones
- **Over-indexing on Gas**: High A's are hard to manage and may conflict
- **Ignoring Brake**: Every team needs quality control and follow-through
- **Neglecting Glue in remote teams**: High B's are critical for culture
- **Using absolute values**: Always use distance from arrow for A, B, C, D

</anti_patterns>

<success_criteria>

Team analysis is complete when:
- [ ] All team members categorized by Gas/Brake/Glue
- [ ] Balance assessed with specific counts
- [ ] Business season considered
- [ ] Gaps identified with impact
- [ ] C trait distribution reviewed
- [ ] A vs B balance assessed
- [ ] Potential conflicts flagged
- [ ] Hiring recommendations provided (if gaps exist)
- [ ] Team strengths documented
- [ ] Watch areas identified

</success_criteria>
