<required_reading>

**Read these reference files before defining a hiring profile:**
1. `references/patterns-archetypes.md` - Pattern identification and role-fit questions
2. `references/primary-traits.md` - A, B, C, D trait details

</required_reading>

<purpose>

Define the ideal Culture Index profile for a role you're hiring. This workflow helps translate job requirements into specific trait positions, identify acceptable patterns, and flag red flags.

</purpose>

<process>

**Step 1: Gather Role Context**

Collect information about the position:

```
Role: [Title]
Reports To: [Manager's pattern if known]
Team Context: [Existing team profiles if available]
Business Stage: [Growth / Consolidation / Turnaround / Stability]
```

**Step 2: Answer Role-Fit Questions**

These three questions determine primary trait positions:

| Question | Answer | Implication |
|----------|--------|-------------|
| Is this role more **macro** or **micro**? | Macro → High A | Micro → Low A |
| Is this position more about **people** or **problems**? | People → High B | Problems → Low B |
| How much **repetition** is in this role? | High repetition → High C | Low repetition → Low C |

**Record your answers:**
- Macro/Micro: [answer] → A should be [High/Low/Normative]
- People/Problems: [answer] → B should be [High/Low/Normative]
- Repetition level: [answer] → C should be [High/Low/Normative]

**Step 3: Determine D Trait (Conformity)**

Ask additional questions:

| Question | If Yes | If No |
|----------|--------|-------|
| Does this role require strict adherence to process? | High D | Low D |
| Are details and precision critical to success? | High D | Low D |
| Will quality failures have significant consequences? | High D | Low D |
| Does the role require creative rule-breaking? | Low D | - |
| Must they challenge status quo to succeed? | Low D | - |

**Record:** D should be [High/Low/Normative]

**Step 4: Map to Ideal Pattern**

Using your answers from Steps 2-3, identify the ideal pattern:

| Role Profile | Trait Combination | Example Roles |
|--------------|-------------------|---------------|
| **Visionary/Architect** | High A, Low C, Low D | CEO, Founder, Strategy Lead |
| **Rainmaker/Persuader** | High A, High B, Low C | Sales, BD, Account Executive |
| **Scholar/Specialist** | Low B, High C, High D | Engineer, Analyst, Researcher |
| **Technical Expert** | Low A, Low B, Low C, High D | Security, QC, Operations |
| **Craftsman** | Low A, Low B, High C, High D | Finance, Compliance, Audit |
| **Accommodator** | Low A, High B, High C | HR, Customer Success, Support |
| **Philosopher** | High A, Low B, High C | Strategy, Research |

**Your ideal pattern:** [Pattern name]

**Step 5: Define Acceptable Range**

Not every hire will be a perfect match. Define acceptable variance:

| Trait | Ideal | Acceptable Range | Hard No |
|-------|-------|------------------|---------|
| A | [High/Low/Norm] | [range] | [extremes to avoid] |
| B | [High/Low/Norm] | [range] | [extremes to avoid] |
| C | [High/Low/Norm] | [range] | [extremes to avoid] |
| D | [High/Low/Norm] | [range] | [extremes to avoid] |

**Guidance for ranges:**
- "Must have": ±1 centile from ideal
- "Strongly prefer": ±2 centiles from ideal
- "Acceptable": ±3 centiles from ideal
- "Hard no": Beyond ±4 centiles

**Step 6: Consider L and I**

Logic (L) and Ingenuity (I) use absolute values:

| Question | If Yes | If No |
|----------|--------|-------|
| Does this role require detached, analytical decision-making? | High L (7-10) | - |
| Does this role require empathy and emotional intelligence? | Low L (0-3) | - |
| Does this role require novel problem-solving and innovation? | High I (7-10) | - |
| Does this role benefit from proven methods over invention? | Low I (0-3) | - |

**Record:**
- L: [range or "any"]
- I: [range or "any"]

**Step 7: Identify Role-Specific Red Flags**

Based on role requirements, flag patterns that would struggle:

| If the role requires... | Red flag pattern | Why |
|-------------------------|------------------|-----|
| Independent decision-making | Very Low A | Needs direction, avoids decisions |
| Customer interaction | Very Low B | May seem cold or disengaged |
| Steady, predictable work | Very Low C | Creates unnecessary urgency |
| Precision and accuracy | Very Low D | Misses details, inconsistent |
| Quick pivots | Very High C | Resists change, slow to adapt |
| Creative solutions | Very High D | Rigid adherence to process |
| Collaboration | Very High A | "Me first," dismissive of others |

**Your red flags:**
1. [Pattern/trait that would fail in this role]
2. [Pattern/trait that would fail in this role]

**Step 8: Consider Team Dynamics**

If team profiles are available:

| Current Team Gap | Hire For |
|------------------|----------|
| No High A (lacking "Gas") | Consider High A |
| No High B (lacking "Glue") | Consider High B |
| No High D (lacking "Brake") | Consider High D |
| All same pattern | Add diversity |
| Existing friction | Avoid intensifying |

**Team consideration notes:** [observations]

**Step 9: Generate Hiring Profile**

Compile the complete hiring profile:

```markdown
## Hiring Profile: [Role Title]

**Date Created:** [Date]
**Created By:** [Name]

### Role Context
- Reports to: [Manager pattern if known]
- Team: [Team composition summary]
- Business stage: [Growth/Consolidation/etc.]

### Ideal Profile

| Trait | Position | Confidence | Notes |
|-------|----------|------------|-------|
| A (Autonomy) | [High/Low/Norm] | [H/M/L] | [reason] |
| B (Social) | [High/Low/Norm] | [H/M/L] | [reason] |
| C (Pace) | [High/Low/Norm] | [H/M/L] | [reason] |
| D (Conformity) | [High/Low/Norm] | [H/M/L] | [reason] |
| L (Logic) | [range or any] | [H/M/L] | [reason] |
| I (Ingenuity) | [range or any] | [H/M/L] | [reason] |

**Target Pattern:** [Pattern name]

### Acceptable Alternatives
- [Alternative pattern 1] - [why acceptable]
- [Alternative pattern 2] - [why acceptable]

### Red Flags (Do Not Hire)
1. [Pattern/trait] - [why problematic for this role]
2. [Pattern/trait] - [why problematic for this role]

### Interview Focus Areas
Based on the ideal profile, explore these areas in interviews:
- [Area 1 based on required traits]
- [Area 2 based on required traits]

### Using This Profile

**With predicted traits (from interview transcript):**
- Compare predicted profile to this template
- Note areas of alignment and concern
- Flag any red flag traits in predicted profile

**With actual CI survey (after offer signed):**
- Compare actual survey to predictions
- Assess fit against this profile
- Identify onboarding considerations based on gaps
```

</process>

<anti_patterns>

Avoid these hiring profile mistakes:

- **Over-specifying**: Requiring exact positions reduces candidate pool unnecessarily
- **Cloning existing team**: Different patterns bring valuable perspectives
- **Ignoring business stage**: Growth needs Gas, consolidation needs Brake
- **Using CI as sole filter**: Profile is one input, not the complete picture
- **Treating traits as skills**: CI measures drives, not capabilities
- **Dismissing normative traits**: Flexibility can be a strength

</anti_patterns>

<success_criteria>

Hiring profile is complete when:
- [ ] Role context documented (reporting, team, stage)
- [ ] All three role-fit questions answered
- [ ] D trait determined with rationale
- [ ] Ideal pattern identified
- [ ] Acceptable ranges defined for all traits
- [ ] L and I requirements specified (or marked as "any")
- [ ] Red flags identified with explanations
- [ ] Team dynamics considered (if team data available)
- [ ] Interview focus areas identified
- [ ] Profile formatted for use in hiring process

</success_criteria>
