<required_reading>

**Read these reference files before analyzing:**
1. `references/primary-traits.md` - Understanding trait movement
2. `references/anti-patterns.md` - Burnout warning signs

</required_reading>

<process>

**Step 1: Load Both Charts**

You need both Survey (top) and Job (bottom) graphs for burnout detection.

Record for each chart:
- Arrow position
- All trait values (A, B, C, D, L, I)
- EU value

**Step 2: Calculate Energy Utilization**

```
Utilization = (Job EU / Survey EU) × 100
```

| Utilization | Status | Interpretation |
|-------------|--------|----------------|
| 70-130% | Healthy | Sustainable workload |
| >130% | **STRESS** | Overutilization, burnout risk |
| <70% | **FRUSTRATION** | Underutilization, flight risk |

**Example**: Survey EU = 41, Job EU = 54 → 54/41 = 132% → STRESS

**Step 3: Compare Arrow Movement**

| Arrow Direction (Survey → Job) | Signal | Meaning |
|--------------------------------|--------|---------|
| Arrow shifts RIGHT | STRESS | Pushing harder than natural |
| Arrow shifts LEFT | FRUSTRATION | Pulling back, disengaging |
| Arrow position unchanged | Stable | Environment matches expectations |

**Step 4: Analyze Each Trait's Movement**

For each trait, compare Survey position to Job position:

| Trait | Survey | Job | Movement | Signal |
|-------|--------|-----|----------|--------|
| A | ? | ? | +/- ? | ? |
| B | ? | ? | +/- ? | ? |
| C | ? | ? | +/- ? | ? |
| D | ? | ? | +/- ? | ? |
| L | ? | ? | +/- ? | ? |
| I | ? | ? | +/- ? | ? |

**Movement interpretation:**

| Trait | Raising | Dropping |
|-------|---------|----------|
| A | Needs to drive/lead more (may be self-induced or required) | Being held back ("Who/what is blocking you?") |
| B | Role requires more relationship building | Role isolates them (demotivating if naturally high B) |
| C | More focus/patience required than comfortable | More urgency/variety required than comfortable |
| D | Expected to be more perfectionist/accountable | Role allows more flexibility |
| L | Trying to be more emotional/open | Compartmentalizing emotions at work |
| I | Trying to be more inventive (traditional approach not working) | Focusing on practical execution |

**Step 5: Identify Polarizing Shifts**

**Critical flag**: When a dot moves from one side of the norm to the other.

Example: D moves from 2nd percentile (left) to 91st percentile (right)
- This is drastic behavior modification
- Almost certainly not sustainable

Document any polarizing shifts:
- [Trait]: Moved from [side] to [opposite side]
- Severity: [moderate/severe]

**Step 6: Check for "Opposite Pattern" Warning**

**Imminent flight risk signal**: When someone's Job behaviors show the opposite of their Survey traits.

Example: Architect (High A, Low C, Low D) → Socializer (Low A, High B, High C) in job
- All dots flipped to opposite side
- This person is in severe stress
- Something must change or they will leave

**Step 7: Identify Stress Sources**

Job behaviors reflect perception of what the role requires. Sources:
1. **Their leader** - Manager expectations/communication
2. **The work itself** - Actual responsibilities
3. **Coworkers** - People they work with

Ask: "Why do they perceive they need to behave this way?"

**Step 8: Calculate 3-6 Month Risk**

If behavior modification continues 3-6+ months, expect:
- Burnout and stress
- Disengagement
- Low morale
- "Mailing it in" (70% effort when capable of 100%)

Assess: How long has this modification been sustained?

**Step 9: Check D Trait Specifically**

D movement is the most common stress indicator:

| D Movement | Signal |
|------------|--------|
| Raising D significantly | Expected to be more perfectionist/accountable than natural |
| D "polarizing" (low to high) | Most common source of unsustainable stress |

**Step 10: Compile Burnout Assessment**

```
## Burnout Risk Assessment: [Name]

### Energy Utilization
- Survey EU: [X]
- Job EU: [X]
- Utilization: [X]%
- Status: [HEALTHY / STRESS / FRUSTRATION]

### Arrow Movement
- Survey arrow: [X]
- Job arrow: [X]
- Direction: [Right=Stress / Left=Frustration / Stable]

### Trait Movement Summary
| Trait | Survey | Job | Change | Concern Level |
|-------|--------|-----|--------|---------------|
| A | | | | Low/Medium/High |
| B | | | | Low/Medium/High |
| C | | | | Low/Medium/High |
| D | | | | Low/Medium/High |

### Polarizing Shifts
- [Any traits that flipped sides]

### Risk Level: [LOW / MODERATE / HIGH / CRITICAL]

### Stress Sources (Likely)
1. [Source 1]
2. [Source 2]

### Recommended Actions
1. [Action 1 - e.g., "Discuss workload with manager"]
2. [Action 2 - e.g., "Resurvey in 3 months"]
3. [Action 3 - e.g., "Consider role adjustment"]

### Timeline
- Current duration estimate: [X months]
- Risk horizon: [When burnout likely if unchanged]
```

</process>

<stress_types>

**>130% (STRESS) has two types:**

1. **Good stress (self-induced)**: "I love this company, I care deeply"
   - Still burnout risk if sustained
   - Health issues possible after 3-6 months

2. **Bad stress (overutilization)**: Too much work OR work requires too much behavior modification
   - More urgent intervention needed
   - May need workload or role adjustment

**<70% (FRUSTRATION):**

- Work doesn't fit their traits
- May have lots to do, but work doesn't match who they are
- Not punching eject yet, but getting close
- Flight risk if not addressed

</stress_types>

<anti_patterns>

Avoid these burnout detection mistakes:

- **Ignoring small EU differences**: Even 10-15% over 130% matters
- **Focusing only on EU**: Trait movement matters too
- **Dismissing "good stress"**: Self-induced stress still causes burnout
- **Using stale data**: Job behaviors should be resurveyed every 6 months
- **Not asking why**: Understand the source before recommending solutions

</anti_patterns>

<success_criteria>

Burnout detection is complete when:
- [ ] Both Survey and Job data analyzed
- [ ] EU utilization calculated
- [ ] Arrow movement identified
- [ ] All trait movements documented
- [ ] Polarizing shifts flagged
- [ ] Risk level assigned (Low/Moderate/High/Critical)
- [ ] Stress sources identified
- [ ] Specific recommendations provided
- [ ] Timeline/horizon assessed

</success_criteria>
