<required_reading>

**Read these reference files before mediation:**
1. `references/primary-traits.md` - A, B, C, D trait details
2. `references/team-composition.md` - Conflict pairs and friction patterns
3. `references/patterns-archetypes.md` - Pattern identification

</required_reading>

<purpose>

Understand why two team members aren't working well together using their Culture Index profiles. This workflow identifies trait-based friction sources and provides specific recommendations for improving the working relationship.

**Important:** CI explains behavioral friction, not personal conflict. If the conflict involves values, ethics, or performance issues, those require separate intervention.

</purpose>

<process>

**Step 1: Load Both Profiles**

```
Person A: [Name]
- Role: [Title]
- Pattern: [Archetype]
- A: [position relative to arrow]
- B: [position relative to arrow]
- C: [position relative to arrow]
- D: [position relative to arrow]
- EU Survey/Job: [values]

Person B: [Name]
- Role: [Title]
- Pattern: [Archetype]
- A: [position relative to arrow]
- B: [position relative to arrow]
- C: [position relative to arrow]
- D: [position relative to arrow]
- EU Survey/Job: [values]
```

**Step 2: Map Trait Differences**

Calculate the gap for each trait:

| Trait | Person A | Person B | Gap | On Same Side? |
|-------|----------|----------|-----|---------------|
| A | [pos] | [pos] | [diff] | [Yes/No] |
| B | [pos] | [pos] | [diff] | [Yes/No] |
| C | [pos] | [pos] | [diff] | [Yes/No] |
| D | [pos] | [pos] | [diff] | [Yes/No] |

**Highest friction risk:** Traits on opposite sides of arrow with large gaps.

**Step 3: Identify Primary Friction Source**

Match trait gaps to known friction patterns:

| Pattern | Source | How It Manifests |
|---------|--------|------------------|
| **High A vs Low A** | Independence vs collaboration | High A acts autonomously; Low A feels excluded. Low A seeks consensus; High A sees it as slow. |
| **High A vs High A** | Power struggle | Both want to lead, neither wants to defer. Competing visions. |
| **High B vs Low B** | Social energy mismatch | High B wants connection; Low B wants focus. High B feels rejected; Low B feels overwhelmed. |
| **High C vs Low C** | Pace mismatch | Low C creates urgency; High C resists rush. High C seems slow; Low C seems chaotic. |
| **High D vs Low D** | Detail orientation | High D focuses on precision; Low D on big picture. High D sees carelessness; Low D sees rigidity. |
| **High D vs High D** | Perfectionism clash | Both critical, both notice flaws. Can become mutual criticism spiral. |

**Your primary friction source:** [Identified pattern]

**Step 4: Understand Each Perspective**

Map how each person likely perceives the other:

**Person A ([Pattern]) likely sees Person B as:**

| Person A's Trait | Person B's Trait | Person A Perceives B As... |
|------------------|------------------|---------------------------|
| High A | Low A | Indecisive, slow, passive |
| Low A | High A | Aggressive, selfish, dismissive |
| High B | Low B | Cold, unfriendly, disconnected |
| Low B | High B | Chatty, distracting, inefficient |
| High C | Low C | Chaotic, impatient, disruptive |
| Low C | High C | Slow, resistant, inflexible |
| High D | Low D | Sloppy, unreliable, careless |
| Low D | High D | Rigid, nitpicky, controlling |

**Person B ([Pattern]) likely sees Person A as:**
[Same analysis from B's perspective]

**Step 5: Assess Relationship Structure**

What is their working relationship?

| Relationship | Additional Dynamics |
|--------------|---------------------|
| Peers | No hierarchy - must find middle ground |
| Manager → Report | Manager should adapt first (they have more power) |
| Report → Manager | Report may need environment change if mismatch is severe |
| Cross-functional | Different priorities compound trait friction |
| Close collaborators | Daily friction accumulates faster |
| Occasional interaction | May be able to limit contact |

**Their relationship:** [Type]

**Step 6: Generate Mediation Approach**

Based on friction source, recommend approach:

**For High A vs Low A friction:**
- Clarify decision rights (who owns what)
- High A: Give Low A explicit input time before decisions
- Low A: Understand High A's autonomy need isn't personal
- Process: Defined consultation points before independent action

**For High B vs Low B friction:**
- Acknowledge different social needs
- High B: Reduce expectations for social interaction from Low B
- Low B: Commit to minimal connection (brief check-ins)
- Process: Scheduled, bounded social interaction

**For High C vs Low C friction:**
- Acknowledge pace difference as legitimate
- Low C: Give advance notice of urgent requests
- High C: Accept some urgency is real, build buffer time
- Process: Deadlines set with High C's processing time in mind

**For High D vs Low D friction:**
- Acknowledge different detail orientations
- High D: Accept "good enough" for some work
- Low D: Use systems to catch critical details
- Process: Clear quality standards for each deliverable type

**For High A vs High A friction:**
- Clear domain ownership (separate turfs)
- Explicit agreement on shared decisions
- Regular alignment to prevent divergent directions
- Process: Leadership defines who owns what

**Your mediation approach:**
1. [Specific recommendation]
2. [Specific recommendation]
3. [Specific recommendation]

**Step 7: Design Process Changes**

Beyond individual adjustments, what process changes would help?

| Friction Source | Process Solution |
|-----------------|------------------|
| Pace mismatch | Define response time expectations, meeting cadence |
| Decision friction | RACI or decision rights matrix |
| Communication style | Agree on preferred channels, formats |
| Detail orientation | Define quality gates and checklists |
| Social needs | Protected focus time vs collaboration time |

**Recommended process changes:**
1. [Specific process change]
2. [Specific process change]

**Step 8: Identify What Won't Change**

CI traits are hardwired. Set realistic expectations:

| Person | Trait | Will Not Change |
|--------|-------|-----------------|
| [Name] | [trait] | [behavior that won't change] |
| [Name] | [trait] | [behavior that won't change] |

**Accept that:**
- [Person A] will continue to [trait-driven behavior]
- [Person B] will continue to [trait-driven behavior]

The goal is accommodation, not transformation.

**Step 9: Check Energy Levels**

Review EU utilization for both parties:

| Person | EU Survey | EU Job | Utilization | Status |
|--------|-----------|--------|-------------|--------|
| [A] | [val] | [val] | [%] | [Healthy/Stress/Frustration] |
| [B] | [val] | [val] | [%] | [Healthy/Stress/Frustration] |

**If either is in stress/frustration:**
- The conflict may be intensifying natural friction
- Address the energy drain as part of mediation
- Consider workload or role adjustment

**Step 10: Compile Mediation Summary**

```markdown
## Conflict Analysis: [Person A] & [Person B]

**Date:** [Date]
**Relationship:** [Peers / Manager-Report / etc.]

### Profile Comparison

| Trait | Person A | Person B | Gap |
|-------|----------|----------|-----|
| A | [pos] | [pos] | [diff] |
| B | [pos] | [pos] | [diff] |
| C | [pos] | [pos] | [diff] |
| D | [pos] | [pos] | [diff] |

**Person A Pattern:** [Archetype]
**Person B Pattern:** [Archetype]

### Primary Friction Source
**[Identified pattern]**

[1-2 sentence explanation of the core conflict driver]

### How They See Each Other

**Person A likely perceives Person B as:**
- [perception based on trait gap]

**Person B likely perceives Person A as:**
- [perception based on trait gap]

### Recommendations

**For Person A:**
1. [Specific adjustment]
2. [Specific adjustment]

**For Person B:**
1. [Specific adjustment]
2. [Specific adjustment]

**Process Changes:**
1. [Process change to reduce friction]
2. [Process change to reduce friction]

### What Won't Change
- [Person A] will continue to [trait behavior] - this is hardwired
- [Person B] will continue to [trait behavior] - this is hardwired

The goal is accommodation, not transformation.

### Energy Status
- Person A: [EU utilization status]
- Person B: [EU utilization status]

[Note any energy concerns]

### Conversation Guide

**Frame the discussion as:**
- Different working styles, not personal conflict
- Both approaches are valid
- Goal is finding workable middle ground

**Avoid:**
- Labeling either person's style as "wrong"
- Expecting either to fundamentally change
- Assuming one must adapt more than the other (unless manager-report)

### Success Indicators
After mediation, look for:
- [ ] Reduced friction in [specific interaction type]
- [ ] Both parties feeling heard
- [ ] Workable process in place for [friction point]
- [ ] Energy levels stabilizing (if previously stressed)

### Escalation Criteria
Escalate beyond CI-based mediation if:
- Conflict involves values, ethics, or harassment
- Performance issues underlie the conflict
- Either party is unwilling to accommodate
- Energy utilization continues declining
```

</process>

<anti_patterns>

Avoid these mediation mistakes:

- **Blaming one party**: Both profiles contribute to friction
- **Expecting transformation**: CI traits don't change - environment does
- **Ignoring power dynamics**: Manager-report relationships require manager to adapt first
- **Over-attributing to CI**: Not all conflict is trait-based
- **Generic advice**: Recommendations must be specific to their trait gaps
- **Forgetting EU signals**: Energy drain indicates escalating friction

</anti_patterns>

<success_criteria>

Conflict mediation is complete when:
- [ ] Both profiles loaded and compared
- [ ] All trait gaps calculated
- [ ] Primary friction source identified
- [ ] Each person's perspective mapped
- [ ] Relationship structure considered
- [ ] Specific recommendations for each person
- [ ] Process changes identified
- [ ] Hardwired behaviors acknowledged (won't change)
- [ ] EU levels checked
- [ ] Conversation guide provided
- [ ] Success indicators defined
- [ ] Escalation criteria noted

</success_criteria>
