# Data Coverage

Valyu's Search API provides access to millions of documents across academic, research, financial, healthcare, and other domains. We index both open-access repositories and premium proprietary sources.

All sources are continuously updated with real-time indexing and automated ingestion.

We also provide web search alongside these data sources for the latest news and information.

Want a source added? Contact us at [team@valyu.ai](mailto:team@valyu.ai).

## Available Datasets

Below are the specific datasets available through Valyu. Use the `included_sources` parameter to target specific datasets, or let Valyu automatically select the most relevant sources for your query.

### Research & Academic

| Dataset | Description | Size | Updates |
|---------|-------------|------|---------|
| valyu/valyu-arxiv | Pre-print research papers from physics, CS, mathematics, quantitative finance, and economics | 2.5M+ papers | Monthly |
| valyu/valyu-pubmed | Open access biomedical and life sciences literature covering medicine, genetics, pharmacology, and epidemiology | 37M+ papers | Monthly |
| valyu/valyu-biorxiv | Life sciences preprints covering neuroscience, molecular biology, bioinformatics, and computational biology | 250K+ papers | Monthly |
| valyu/valyu-medrxiv | Health and clinical research preprints spanning clinical medicine, epidemiology, public health, and oncology | 80K+ papers | Monthly |

### Healthcare & Life Sciences

| Dataset | Description | Size | Updates |
|---------|-------------|------|---------|
| valyu/valyu-clinical-trials | Clinical studies from ClinicalTrials.gov including study design, eligibility, outcomes, and results | 500K+ trials | Real-time |
| valyu/valyu-drug-labels | FDA-approved medication labeling from DailyMed including dosage, warnings, and interactions | 150K+ labels | Real-time |
| valyu/valyu-chembl | Bioactive molecules database from ChEMBL with drug-like properties, bioactivity data, and target information | 2.5M+ compounds | Monthly |
| valyu/valyu-drugbank | Comprehensive drug database from DrugBank with mechanisms, targets, pharmacology, and interactions | 15K+ drugs | Monthly |
| valyu/valyu-open-targets | Drug target validation platform with disease associations, genetic evidence, and target tractability data | 60K+ targets | Monthly |
| valyu/valyu-npi-registry | US National Provider Identifier registry with healthcare provider details, specialties, and practice locations | 8M+ providers | Real-time |
| valyu/valyu-who-icd | WHO International Classification of Diseases with ICD-10 and ICD-11 codes for diagnosis and billing | 70K+ codes | Monthly |
| valyu/valyu-nih-grants | NIH research funding data including project descriptions, investigators, and funding amounts | 2M+ grants | Real-time |
| valyu/valyu-who-health-data | Global health statistics from WHO covering 194 countries with disease, health system, and demographic data | 5M+ records | Real-time |

### Financial Markets

| Dataset | Description | Size | Updates |
|---------|-------------|------|---------|
| valyu/valyu-stocks | Real-time and historical stock prices across 75 exchanges globally | 200K+ stocks | Real-time |
| valyu/valyu-crypto | Real-time cryptocurrency prices including open, high, low, close, volume, and market cap | 200+ coins | Real-time |
| valyu/valyu-forex | Foreign exchange rates for currency pairs worldwide | 180+ pairs | Real-time |
| valyu/valyu-etfs | Exchange-traded fund prices and data globally | 25K+ ETFs | Real-time |
| valyu/valyu-funds | Mutual fund prices and metadata | 10K+ funds | Real-time |
| valyu/valyu-commodities | Commodity futures prices including oil, gold, metals, and agriculture | 60+ commodities | Real-time |
| valyu/valyu-market-movers-US | Biggest gainers, losers, and most active stocks in US markets | Daily | Daily |

### Company Fundamentals

| Dataset | Description | Size | Updates |
|---------|-------------|------|---------|
| valyu/valyu-sec-filings | SEC regulatory documents including 10-K, 10-Q, and 8-K filings with semantic search | 3M+ filings | Daily |
| valyu/valyu-earnings-US | Quarterly and annual earnings data including EPS, revenue, and analyst estimates | 10K+ companies | Real-time |
| valyu/valyu-balance-sheet-US | Balance sheet data including assets, liabilities, equity, and debt | 10K+ companies | Quarterly |
| valyu/valyu-income-statement-US | Income statement data including revenue, gross profit, and net income | 10K+ companies | Quarterly |
| valyu/valyu-cash-flow-US | Cash flow statements including operating, investing, and financing flows | 10K+ companies | Quarterly |
| valyu/valyu-dividends-US | Dividend payment history including amounts, ex-dates, and payment dates | 10K+ companies | Daily |
| valyu/valyu-statistics-US | Key financial metrics including P/E, market cap, beta, and ROE | 10K+ companies | Daily |
| valyu/valyu-insider-transactions-US | Insider trading activity by executives, directors, and major shareholders | 10K+ companies | Daily |

### Economic Data

| Dataset | Description | Size | Updates |
|---------|-------------|------|---------|
| valyu/valyu-fred | Federal Reserve Economic Data with 800K+ time series covering GDP, inflation, interest rates, and more | 50M+ records | Real-time |
| valyu/valyu-bls | Bureau of Labor Statistics data on employment, wages, CPI, and productivity | 10M+ records | Real-time |
| valyu/valyu-destatis-labor | German labour market statistics from Destatis including employment, wages, and regional data | 15M+ records | Monthly |
| valyu/valyu-worldbank-indicators | World Bank development indicators for 200+ countries covering economic, social, and environmental metrics | 2M+ records | Real-time |
| valyu/valyu-usaspending | US federal spending data including contracts, grants, and awards across all agencies | 40M+ records | Real-time |

### Prediction Markets

| Dataset | Description | Size | Updates |
|---------|-------------|------|---------|
| valyu/valyu-polymarket | Polymarket prediction market data including events, prices, volumes, and liquidity | 100K+ markets | Real-time |
| valyu/valyu-kalshi | Kalshi prediction market data including events, outcomes, and pricing | 100K+ markets | Real-time |

### Transportation

| Dataset | Description | Size | Updates |
|---------|-------------|------|---------|
| valyu/valyu-global-ship-tracking | Real-time vessel positions and AIS data for ships worldwide including speed, heading, and status | 5M+ vessels | Real-time |
| valyu/valyu-uk-national-rail | Live UK train departures, arrivals, platform info, delays, and cancellations | 1M+ records | Real-time |

### Patents & IP

| Dataset | Description | Size | Updates |
|---------|-------------|------|---------|
| valyu/valyu-patents | US patent filings from 2001 onwards including utility, design, and plant patents | 8M+ patents | Weekly |

## Domain Coverage Summary

### Research Coverage

| Domain | Description | Coverage |
|--------|-------------|----------|
| Natural Sciences | Physics, chemistry, biology, astronomy, earth sciences | High |
| Mathematics & Statistics | Pure/applied maths, statistics, probability | High |
| Computer Science | AI, ML, software, systems, HCI, security | High |
| Engineering | Electrical, mechanical, civil, materials | Medium |
| Psychology & Cognitive Sciences | Human behaviour, cognition, neuroscience | Medium |
| Social Sciences | Sociology, politics, education, law | Low |
| Humanities | History, philosophy, literature, religion | Low |
| Environmental & Earth Sciences | Climate, ecology, geology, oceans | Medium |
| Medical & Health Sciences | Clinical medicine, public health, biomedicine | High |
| Business & Management | Finance, marketing, strategy, accounting | High |

### Coming Soon

| Data Type | Description | Status |
|-----------|-------------|--------|
| International Markets | Stock data for European, Asian, and emerging markets | Coming Soon |
| Flight Data | Real-time and historical flight tracking, schedules, and aviation data | Coming Soon |
| Trucking & Freight | Logistics, freight rates, and trucking industry data | Coming Soon |
| Additional Economic Data | Trade statistics, housing data, and regional economic indicators | Coming Soon |
| Additional Drug Data | Drug adverse events and pharmaceutical pipelines | Coming Soon |
| UK Legislation | UK laws and legal documents | Coming Soon |
| Private Company Data | Startup profiles, valuations, funding rounds | On the Roadmap |

---

*Data coverage statistics updated daily. Contact us at [team@valyu.ai](mailto:team@valyu.ai) for specific domain requirements or custom data partnerships.*
